/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.handlers.party;

import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.chat.ChatHandler;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMembers;
import earth.terrarium.argonauts.common.network.messages.ClientboundSyncPartiesPacket;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PartyHandler
implements PartyApi {
    private static final Map<UUID, Party> PARTIES = new HashMap<UUID, Party>();
    private static final Map<UUID, UUID> PLAYER_PARTIES = new HashMap<UUID, UUID>();

    @Override
    public void createParty(class_3222 player) throws MemberException {
        if (PLAYER_PARTIES.containsKey(player.method_5667())) {
            throw MemberException.ALREADY_IN_PARTY;
        }
        UUID id = (UUID)CommonUtils.generate(Predicate.not(PARTIES::containsKey), UUID::randomUUID);
        Party party = new Party(id, (class_1657)player);
        PARTIES.put(id, party);
        PLAYER_PARTIES.put(player.method_5667(), id);
        ModUtils.sendToAllClientPlayers(new ClientboundSyncPartiesPacket(Set.of(party), Set.of()), player.field_13995);
        player.method_7353(ConstantComponents.PARTY_CREATE, false);
    }

    @Override
    @Nullable
    public Party get(UUID id) {
        return PARTIES.get(id);
    }

    @Override
    @Nullable
    public Party get(class_1657 player) {
        return this.getPlayerParty(player.method_5667());
    }

    @Override
    @Nullable
    public Party getPlayerParty(UUID player) {
        return this.get(PLAYER_PARTIES.get(player));
    }

    @Override
    public void join(Party party, class_3222 player) throws MemberException {
        if (PLAYER_PARTIES.containsKey(player.method_5667())) {
            throw MemberException.ALREADY_IN_PARTY;
        }
        if (party.ignored().has(player.method_5667())) {
            throw MemberException.NOT_ALLOWED_TO_JOIN_PARTY;
        }
        if (party.isPublic() || ((PartyMembers)party.members()).isInvited(player.method_5667())) {
            for (Member member : (PartyMembers)party.members()) {
                class_3222 serverPlayer = player.field_13995.method_3760().method_14602(member.profile().getId());
                if (serverPlayer == null) continue;
                serverPlayer.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.party_perspective_join", (Object[])new Object[]{player.method_5477().getString(), ((PartyMember)((PartyMembers)party.members()).getLeader()).profile().getName()}), false);
            }
        } else {
            throw MemberException.NOT_ALLOWED_TO_JOIN_PARTY;
        }
        ((PartyMembers)party.members()).add(player.method_7334());
        PLAYER_PARTIES.put(player.method_5667(), party.id());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncPartiesPacket(Set.of(party), Set.of()), player.field_13995);
        player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.party_join", (Object[])new Object[]{((PartyMember)((PartyMembers)party.members()).getLeader()).profile().getName()}), false);
    }

    @Override
    public void leave(UUID id, class_3222 player) throws MemberException {
        Party party = this.get(id);
        if (party == null) {
            throw MemberException.PARTY_DOES_NOT_EXIST;
        }
        if (PLAYER_PARTIES.get(player.method_5667()) != id) {
            throw MemberException.PLAYER_IS_NOT_IN_PARTY;
        }
        if (((PartyMembers)party.members()).isLeader(player.method_5667())) {
            throw MemberException.YOU_CANT_REMOVE_PARTY_LEADER;
        }
        PLAYER_PARTIES.remove(player.method_5667());
        ((PartyMembers)party.members()).remove(player.method_5667());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncPartiesPacket(Set.of(party), Set.of()), player.field_13995);
        player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.party_leave", (Object[])new Object[]{((PartyMember)((PartyMembers)party.members()).getLeader()).profile().getName()}), false);
        for (Member member : (PartyMembers)party.members()) {
            class_3222 serverPlayer = player.field_13995.method_3760().method_14602(member.profile().getId());
            if (serverPlayer == null) continue;
            serverPlayer.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.party_perspective_leave", (Object[])new Object[]{player.method_5477().getString(), ((PartyMember)((PartyMembers)party.members()).getLeader()).profile().getName()}), false);
        }
    }

    @Override
    public void disband(Party party, MinecraftServer server) {
        PARTIES.remove(party.id());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncPartiesPacket(Set.of(), Set.of(party.id())), server);
        ((PartyMembers)party.members()).forEach(member -> {
            if (PLAYER_PARTIES.get(member.profile().getId()) == party.id()) {
                PLAYER_PARTIES.remove(member.profile().getId());
            }
        });
        ChatHandler.remove(party, ChatMessageType.PARTY);
        class_3222 player = server.method_3760().method_14602(((PartyMember)((PartyMembers)party.members()).getLeader()).profile().getId());
        if (player == null) {
            return;
        }
        player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.party_disband", (Object[])new Object[]{player.method_5477().getString()}), false);
    }

    @Override
    public Collection<Party> getAll() {
        return PARTIES.values();
    }
}

