/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.handlers.guild;

import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.argonauts.Argonauts;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.compat.cadmus.CadmusIntegration;
import earth.terrarium.argonauts.common.compat.heracles.HeraclesIntegration;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.handlers.guild.settings.GuildSettings;
import earth.terrarium.argonauts.common.network.messages.ClientboundSyncGuildsPacket;
import earth.terrarium.argonauts.common.utils.EventUtils;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GuildHandler
extends SaveHandler
implements GuildApi {
    private final Map<UUID, Guild> guilds = new HashMap<UUID, Guild>();
    private final Map<UUID, UUID> playerGuilds = new HashMap<UUID, UUID>();

    public void loadData(class_2487 tag) {
        for (String key : tag.method_10541()) {
            class_5250 name;
            UUID id = UUID.fromString(key);
            class_2487 guildTag = tag.method_10562(key);
            class_2487 settingsTag = guildTag.method_10562("settings");
            class_2487 membersTag = guildTag.method_10562("members");
            class_2487 alliesTag = guildTag.method_10562("allies");
            class_2499 fakePlayersTag = guildTag.method_10554("fakePlayers", 8);
            GuildSettings settings = new GuildSettings();
            if (!settingsTag.method_10562("hq").method_33133()) {
                settings.setHq(ModUtils.readGlobalPos(settingsTag.method_10562("hq")));
            }
            settings.setDisplayName((class_2561)((name = class_2561.class_2562.method_10877((String)settingsTag.method_10558("name"))) == null ? class_5244.field_39003 : name));
            class_5250 motd = class_2561.class_2562.method_10877((String)settingsTag.method_10558("motd"));
            settings.setMotd((class_2561)(motd == null ? class_5244.field_39003 : motd));
            settings.setColor(class_124.method_534((int)settingsTag.method_10571("color")));
            settings.setAllowFakePlayers(settingsTag.method_10577("allowFakePlayers"));
            GuildMembers members = new GuildMembers(ModUtils.readBasicProfile(guildTag.method_10562("owner")));
            membersTag.method_10541().forEach(memberTag -> members.add(ModUtils.readBasicProfile(membersTag.method_10562(memberTag))));
            alliesTag.method_10541().forEach(allyTag -> members.ally(ModUtils.readBasicProfile(alliesTag.method_10562(allyTag))));
            for (class_2520 tag1 : fakePlayersTag) {
                String uuidText = tag1.method_10714();
                UUID uuid = ModUtils.parseUuidOrNull(uuidText);
                if (uuid != null) {
                    members.fakePlayers().add(uuid);
                    continue;
                }
                Constants.LOGGER.warn("Failed to parse fake player uuid of {} in guild {}", (Object)uuidText, (Object)id);
            }
            Guild guild = new Guild(id, settings, members);
            this.guilds.put(id, guild);
            this.updateInternal();
        }
    }

    public void saveData(class_2487 tag) {
        this.guilds.forEach((uuid, guild) -> {
            class_2487 guildTag = new class_2487();
            class_2487 settingsTag = new class_2487();
            class_2487 membersTag = new class_2487();
            class_2487 alliesTag = new class_2487();
            class_2499 fakePlayersTag = new class_2499();
            settingsTag.method_10566("hq", (class_2520)(guild.settings().hq().isPresent() ? ModUtils.writeGlobalPos(guild.settings().hq().get()) : new class_2487()));
            settingsTag.method_10582("name", class_2561.class_2562.method_10867((class_2561)guild.settings().displayName()));
            settingsTag.method_10582("motd", class_2561.class_2562.method_10867((class_2561)guild.settings().motd()));
            settingsTag.method_10567("color", (byte)guild.settings().color().method_536());
            settingsTag.method_10556("allowFakePlayers", guild.settings().allowFakePlayers());
            guildTag.method_10566("settings", (class_2520)settingsTag);
            guildTag.method_10566("owner", (class_2520)ModUtils.writeBasicProfile(((GuildMember)((GuildMembers)guild.members()).getLeader()).profile()));
            ((GuildMembers)guild.members()).forEach(member -> membersTag.method_10566(member.profile().getId().toString(), (class_2520)ModUtils.writeBasicProfile(member.profile())));
            ((GuildMembers)guild.members()).allies().forEach(member -> alliesTag.method_10566(member.profile().getId().toString(), (class_2520)ModUtils.writeBasicProfile(member.profile())));
            ((GuildMembers)guild.members()).fakePlayers().forEach(fakePlayer -> fakePlayersTag.add((Object)class_2519.method_23256((String)fakePlayer.toString())));
            guildTag.method_10566("members", (class_2520)membersTag);
            guildTag.method_10566("allies", (class_2520)alliesTag);
            guildTag.method_10566("fakePlayers", (class_2520)fakePlayersTag);
            tag.method_10566(uuid.toString(), (class_2520)guildTag);
        });
    }

    public static GuildHandler read(MinecraftServer server) {
        return (GuildHandler)GuildHandler.read((class_26)server.method_30002().method_17983(), GuildHandler::new, (String)"argonauts_guilds");
    }

    @Override
    public void createGuild(class_3222 player, class_2561 displayName) throws MemberException {
        GuildHandler data = GuildHandler.read(player.field_13995);
        if (data.playerGuilds.containsKey(player.method_5667())) {
            throw MemberException.ALREADY_IN_GUILD;
        }
        UUID id = (UUID)CommonUtils.generate(Predicate.not(data.guilds::containsKey), UUID::randomUUID);
        Guild guild = new Guild(id, (class_1657)player);
        guild.settings().setDisplayName(displayName);
        data.guilds.put(id, guild);
        data.playerGuilds.put(player.method_5667(), id);
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(guild), Set.of()), player.field_13995);
        player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_create", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        EventUtils.created(guild, player);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.addToCadmusTeam(player, id.toString());
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.updateHeraclesChanger(player);
        }
    }

    @Override
    @Nullable
    public Guild get(MinecraftServer server, UUID id) {
        return GuildHandler.read((MinecraftServer)server).guilds.get(id);
    }

    @Override
    @Nullable
    public Guild get(class_3222 player) {
        return this.getPlayerGuild(player.field_13995, player.method_5667());
    }

    @Override
    @Nullable
    public Guild getPlayerGuild(MinecraftServer server, UUID player) {
        GuildHandler data = GuildHandler.read(server);
        return data.guilds.get(data.playerGuilds.get(player));
    }

    @Override
    public Collection<Guild> getAll(MinecraftServer server) {
        return GuildHandler.read((MinecraftServer)server).guilds.values();
    }

    @Override
    public void tryJoin(Guild guild, class_3222 player) throws MemberException {
        if (!guild.isPublic() && !((GuildMembers)guild.members()).isInvited(player.method_5667())) {
            throw MemberException.NOT_ALLOWED_TO_JOIN_GUILD;
        }
        this.join(guild, player);
    }

    @Override
    public void join(Guild guild, class_3222 player) throws MemberException {
        GuildHandler data = GuildHandler.read(player.field_13995);
        if (data.playerGuilds.containsKey(player.method_5667())) {
            throw MemberException.ALREADY_IN_GUILD;
        }
        for (Member member : (GuildMembers)guild.members()) {
            class_3222 serverPlayer = player.field_13995.method_3760().method_14602(member.profile().getId());
            if (serverPlayer == null) continue;
            serverPlayer.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_perspective_join", (Object[])new Object[]{player.method_5477().getString(), guild.settings().displayName().getString()}), false);
        }
        ((GuildMembers)guild.members()).add(player.method_7334());
        data.playerGuilds.put(player.method_5667(), guild.id());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(guild), Set.of()), player.field_13995);
        player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_join", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        EventUtils.joined(guild, player);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.addToCadmusTeam(player, guild.id().toString());
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.updateHeraclesChanger(player);
        }
    }

    @Override
    public void leave(UUID id, class_3222 player) throws MemberException {
        GuildHandler data = GuildHandler.read(player.field_13995);
        Guild guild = this.get(player.field_13995, id);
        if (guild == null) {
            throw MemberException.GUILD_DOES_NOT_EXIST;
        }
        if (data.playerGuilds.get(player.method_5667()) != id) {
            throw MemberException.PLAYER_IS_NOT_IN_GUILD;
        }
        if (((GuildMembers)guild.members()).isLeader(player.method_5667())) {
            throw MemberException.YOU_CANT_REMOVE_GUILD_OWNER;
        }
        ((GuildMembers)guild.members()).remove(player.method_5667());
        player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_leave", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        for (Member member : (GuildMembers)guild.members()) {
            class_3222 serverPlayer = player.field_13995.method_3760().method_14602(member.profile().getId());
            if (serverPlayer == null) continue;
            serverPlayer.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_perspective_leave", (Object[])new Object[]{player.method_5477().getString(), guild.settings().displayName().getString()}), false);
        }
        data.playerGuilds.remove(player.method_5667());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(guild), Set.of()), player.field_13995);
        EventUtils.left(guild, player);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.removeFromCadmusTeam(player, id.toString());
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.updateHeraclesChanger(player);
        }
    }

    @Override
    public void disband(Guild guild, MinecraftServer server) {
        class_3222 player = server.method_3760().method_14602(((GuildMember)((GuildMembers)guild.members()).getLeader()).profile().getId());
        if (player == null) {
            return;
        }
        player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_disband", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        EventUtils.disbanned(guild);
        this.remove(false, guild, server);
    }

    @Override
    public void remove(boolean force, Guild guild, MinecraftServer server) {
        GuildHandler data = GuildHandler.read(server);
        data.guilds.remove(guild.id());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(), Set.of(guild.id())), server);
        EventUtils.removed(force, guild);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.disbandCadmusTeam(guild, server);
        }
        if (Argonauts.isHeraclesLoaded()) {
            ((GuildMembers)guild.members()).forEach(m -> HeraclesIntegration.updateHeraclesChanger(server.method_30002(), m.profile().getId()));
        }
        data.updateInternal();
    }

    private void updateInternal() {
        this.playerGuilds.clear();
        this.guilds.values().forEach(team -> ((GuildMembers)team.members()).forEach(member -> this.playerGuilds.put(member.profile().getId(), team.id())));
    }

    public boolean method_79() {
        return true;
    }
}

