/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.chat.messages;

import com.google.common.primitives.UnsignedInteger;
import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import earth.terrarium.argonauts.client.screens.chat.messages.ChatMessageListEntry;
import earth.terrarium.argonauts.client.screens.chat.messages.ChatPlayerListEntry;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ChatMessagesList
extends SelectionList<ListEntry> {
    private static final Pattern URL_PATTERN = Pattern.compile("https?://(?:www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b(?:[-a-zA-Z0-9()@:%_+.~#?&/=]*)");

    public ChatMessagesList(int x, int y) {
        super(x, y, 184, 120, 10, entry -> {}, true);
    }

    public void update(LinkedHashMap<UnsignedInteger, ChatMessage> messages) {
        ListEntry last = null;
        for (Map.Entry<UnsignedInteger, ChatMessage> entry : messages.entrySet()) {
            UnsignedInteger id = entry.getKey();
            ChatMessage message = entry.getValue();
            last = this.addMessage(id, message);
        }
        if (last != null) {
            this.ensureVisible(last);
        }
    }

    public ListEntry addMessage(UnsignedInteger id, ChatMessage message) {
        ChatMessageListEntry last = null;
        this.addEntry(new ChatPlayerListEntry(id, message));
        class_2561 text = ChatMessagesList.formatComponent(message.message());
        for (class_5481 sequence : class_310.method_1551().field_1772.method_1728((class_5348)text, 176)) {
            last = new ChatMessageListEntry(id, sequence);
            this.addEntry(last);
        }
        return last;
    }

    private static class_2561 formatComponent(String text) {
        text = text.replace("\n", " ");
        Matcher matcher = URL_PATTERN.matcher(text);
        class_5250 component = class_2561.method_43473();
        int last = 0;
        while (matcher.find()) {
            String url = matcher.group();
            component.method_10852((class_2561)class_2561.method_43470((String)text.substring(last, matcher.start())));
            class_5250 link = class_2561.method_43470((String)url).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1078).method_10958(new class_2558(class_2558.class_2559.field_11749, url)));
            component.method_10852((class_2561)link);
            last = matcher.end();
        }
        component.method_10852((class_2561)class_2561.method_43470((String)text.substring(last)));
        return component;
    }

    public void deleteMessage(UnsignedInteger id) {
        ArrayList<ListEntry> toRemove = new ArrayList<ListEntry>();
        for (ListEntry child : this.method_25396()) {
            ChatMessageListEntry entry;
            if (child instanceof ChatPlayerListEntry) {
                ChatPlayerListEntry entry2 = (ChatPlayerListEntry)child;
                if (!entry2.id().equals((Object)id)) continue;
                toRemove.add(entry2);
                continue;
            }
            if (!(child instanceof ChatMessageListEntry) || !(entry = (ChatMessageListEntry)child).id().equals((Object)id)) continue;
            toRemove.add(entry);
        }
        for (ListEntry entry : toRemove) {
            this.removeEntry(entry);
        }
    }
}

