/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.rendering;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlTexture
extends class_1049 {
    private static final Map<String, Info> INFO = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Info DEFAULT_INFO = new Info(24, 24, 24, 24);
    private static final class_2960 DEFAULT_TEXTURE = new class_2960("argonauts", "textures/gui/hourglass.png");
    private final String url;
    private boolean loaded;
    private CompletableFuture<?> loader;

    public UrlTexture(String url) {
        super(DEFAULT_TEXTURE);
        this.url = url;
    }

    public static class_2960 getTextureId(String url) {
        return new class_2960("argonauts", "urlimages/" + Hashing.sha1().hashUnencodedChars((CharSequence)url));
    }

    public static Info getInfo(String url) {
        return INFO.getOrDefault(url, DEFAULT_INFO);
    }

    private void upload(class_1011 image) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)image.method_4307(), (int)image.method_4323());
        image.method_4301(0, 0, 0, true);
        INFO.put(this.url, Info.from(image));
    }

    public void method_4625(@NotNull class_3300 manager) {
        class_310.method_1551().execute(() -> {
            if (!this.loaded) {
                try {
                    super.method_4625(manager);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.loaded = true;
            }
        });
        if (this.loader == null) {
            this.loader = CompletableFuture.runAsync(() -> WebUtils.get((String)this.url, HttpResponse.BodyHandlers.ofInputStream()).ifPresent(response -> {
                if (response.statusCode() / 100 == 2) {
                    class_1011 image = this.loadTexture((InputStream)response.body());
                    class_310.method_1551().execute(() -> {
                        if (image != null) {
                            class_310.method_1551().execute(() -> {
                                this.loaded = true;
                                if (!RenderSystem.isOnRenderThread()) {
                                    RenderSystem.recordRenderCall(() -> this.upload(image));
                                } else {
                                    this.upload(image);
                                }
                            });
                        }
                    });
                }
            }), class_156.method_18349());
        }
    }

    @Nullable
    private class_1011 loadTexture(InputStream stream) {
        class_1011 nativeImage = null;
        try {
            nativeImage = class_1011.method_4309((InputStream)stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nativeImage;
    }

    public record Info(int width, int height, int displayWidth, int displayHeight) {
        public static Info from(class_1011 image) {
            double widthMultiple = Math.ceil((double)image.method_4307() / 150.0);
            double heightMultiple = Math.ceil((double)image.method_4323() / 100.0);
            int ratio = (int)Math.max(widthMultiple, heightMultiple);
            return new Info(image.method_4307(), image.method_4323(), image.method_4307() / ratio, image.method_4323() / ratio);
        }
    }
}

