/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.api.party;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.party.members.IgnoredPartyMembers;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMembers;
import earth.terrarium.argonauts.common.handlers.party.settings.PartySettings;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;

public final class Party
extends Group<PartyMember, PartyMembers> {
    private final PartySettings settings;
    private final IgnoredPartyMembers ignored;
    public static final ByteCodec<Party> BYTE_CODEC = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.UUID.fieldOf(Group::id), (ObjectEntryByteCodec)PartySettings.BYTE_CODEC.fieldOf(Party::settings), (ObjectEntryByteCodec)PartyMembers.BYTE_CODEC.fieldOf(Group::members), (ObjectEntryByteCodec)ByteCodec.UUID.setOf().map(IgnoredPartyMembers::new, IgnoredPartyMembers::getIgnored).fieldOf(Party::ignored), Party::new);

    public Party(UUID id, PartySettings settings, PartyMembers members, IgnoredPartyMembers ignored) {
        super(id, members);
        this.settings = settings;
        this.ignored = ignored;
    }

    public Party(UUID id, class_1657 leader) {
        this(id, new PartySettings(), new PartyMembers(leader.method_7334()), new IgnoredPartyMembers());
    }

    @Override
    public boolean isPublic() {
        return this.settings.has("public");
    }

    @Override
    public PartyMember getMember(UUID player) throws MemberException {
        if (!((PartyMembers)this.members()).isMember(player)) {
            throw MemberException.YOU_ARE_NOT_IN_THIS_PARTY;
        }
        return (PartyMember)((PartyMembers)this.members()).get(player);
    }

    public PartySettings settings() {
        return this.settings;
    }

    public IgnoredPartyMembers ignored() {
        return this.ignored;
    }

    public boolean friendlyFireEnabled() {
        return this.settings.has("friendly_fire");
    }

    @Override
    public class_2561 displayName() {
        return CommonUtils.serverTranslatable((String)"text.argonauts.party_name", (Object[])new Object[]{((PartyMember)((PartyMembers)this.members()).getLeader()).profile().getName()});
    }

    @Override
    public class_124 color() {
        return class_124.field_1068;
    }
}

